/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.signals.api.SignalsBaseRestHandler;
import com.floragunn.signals.confconv.ConversionResult;
import com.floragunn.signals.confconv.es.EsWatcherConverter;
import com.floragunn.signals.watch.Watch;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ConvertWatchApiAction
extends SignalsBaseRestHandler {
    public ConvertWatchApiAction(Settings settings) {
        super(settings);
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, "/_signals/convert/es"));
    }

    protected final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        try {
            DocNode input = DocNode.parse((Format)Format.JSON).from(request.content().utf8ToString());
            EsWatcherConverter converter = new EsWatcherConverter(input);
            ConversionResult<Watch> result = converter.convertToSignals();
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, ConvertWatchApiAction.convertToJson(channel, (ToXContent)new Result((Watch)result.getElement(), result.getSourceValidationErrors()), Watch.WITHOUT_AUTH_TOKEN)));
        }
        catch (ConfigValidationException e) {
            return channel -> this.errorResponse((RestChannel)channel, RestStatus.BAD_REQUEST, e.getMessage(), e.getValidationErrors().toJsonString());
        }
    }

    public String getName() {
        return "Create Watch Action";
    }

    static class Result
    implements ToXContentObject {
        final Watch watch;
        final ValidationErrors validationErrors;
        final String message;

        Result(Watch watch, ValidationErrors validationErrors) {
            this.watch = watch;
            this.validationErrors = validationErrors;
            this.message = validationErrors.size() == 0 ? "Watch was successfully converted" : (validationErrors.size() == 1 ? "Watch was partially converted; One problem was encountered for attribute " + validationErrors.getOnlyValidationError().getAttribute() + ": " + validationErrors.getOnlyValidationError().getMessage() : "Watch was partially converted; " + validationErrors.size() + " problems encountered. See detail list.");
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("status", this.message);
            builder.field("signals_watch", (ToXContent)this.watch);
            if (this.validationErrors.size() > 1) {
                builder.field("detail", this.validationErrors.toMap());
            }
            builder.endObject();
            return builder;
        }
    }
}

